*
* UDP SUPPORT FOR MARINA
*
UDPDATLEN DS 2 ; LENGTH OF DATA PAYLOAD
UDPFPORT DS 2 ; INCOMING SOURCE PORT
*
* INCOMING UDP DATAGRAM HANDLER
*
HANDLEUDP
 CLC  ; COMPUTE LENGTH OF DATA PAYLOAD
 LDA IPHEADLEN
 ADC #5
 TAY  ; POINT TO UDP LENGTH
 SEC
 LDA (INPBUF),Y
 SBC #8 ; LENGTH OF UDP HEAD
 STA UDPDATLEN
 DEY
 LDA (INPBUF),Y
 SBC #0
 STA UDPDATLEN+1
* DID SENDER COMPUTE A CHECKSUM?
 CLC
 LDA IPHEADLEN
 ADC #6 ; POINT TO UDP CHECKSUM
 TAY
 LDA (INPBUF),Y
 INY
 ORA (INPBUF),Y
 BEQ :NOCHKSUM
* VERIFY THE CHECKSUM
* WE NEED TO SETUP 3 DATA AREAS BEFORE CALLING THE
* UDP CHECKSUM ROUTINE.
 LDA UDPDATLEN
 STA CHKSUMLEN
 LDA UDPDATLEN+1
 STA CHKSUMLEN+1
* SETUP PTR AND PTR2 FOR IP HEAD AND UDP DATA PAYLOAD
 CLC
 LDA INPBUF
 STA PTR
 ADC IPHEADLEN
 STA PTR2
 LDA INPBUF+1
 STA PTR+1
 ADC #0
 STA PTR2+1
* MOVE PTR2 8 BYTES PAST THE UDP HEAD
 CLC
 LDA PTR2
 ADC #8
 STA PTR2
 LDA PTR2+1
 ADC #0
 STA PTR2+1
 JSR UDPCHKSUM
*
 ORA CHKSUM+1
 BNE :BADCHKSUM
* CHECKSUM OK
 DO DEBUG
 LDA #"+"
 JSR COUT
 FIN
 JMP :INCP
* CHECKSUM BAD
:BADCHKSUM
 DO DEBUG
 LDA #"@"
 JSR COUT
 FIN
 SEC
 RTS
*
:NOCHKSUM
 DO DEBUG
 LDA #"/"
 JSR COUT
 FIN
*
:INCP CLC
 LDA INPBUF ; ADVANCE THE POINTER...
 ADC IPHEADLEN ; ...TO THE UDP DATA
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 DO DEBUG
* PRINT THE SOURCE PORT
 LDA #" "
 JSR COUT
 LDA #"S"
 JSR COUT
 LDY #0
:L LDA MSG9,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :L
 FIN
:NEXT LDY #1 ; POINT TO LOW-BYTE OF SRC PORT
 LDA (INPBUF),Y
 STA UDPFPORT
 TAX
 DEY
 LDA (INPBUF),Y
 STA UDPFPORT+1
 DO DEBUG
 JSR PRNTAX
 LDA #" "
 JSR COUT
 LDA #"D"
 JSR COUT
 LDY #0
:L2 LDA MSG9,Y
 BEQ :NEXT2
 JSR COUT
 INY
 BNE :L2
:NEXT2 LDY #3 ; DESTINATION PORT
 LDA (INPBUF),Y
 TAX
 DEY
 LDA (INPBUF),Y
 JSR PRNTAX
 FIN
*
* PORT 0 IS RESERVED, PER RFC 1340, PAGE 9
*
 LDY #3 ; DESTINATION PORT
 LDA (INPBUF),Y
 DEY
 ORA (INPBUF),Y
 BEQ :UDPDONE ; ILLEGAL DEST. PORT
*
* CHECK FOR A DHCP SERVER REPLY
*
 LDY #3 ; DESTINATION PORT
 LDA (INPBUF),Y
 CMP #68
 BNE :SOCKETS
 DEY
 LDA (INPBUF),Y
 BNE :SOCKETS
 JMP DHCPREPLY ; CORRECT PORT, SO SEND IT TO DHCP
*
* AFTER THE DHCP REPLY IS PROCESSED, PROGRAM CONTROL SHOULD
* -NOT- REACH THE SOCKETS CODE BELOW.
*

:SOCKETS
*
* SOCKETS
* SOME OF THIS CODE IS FOR DEBUGGING AND SHOULD BE REMOVED
* LATER. HOWEVER, SOCKETS DO NEED TO BE PROCESSED HERE.
*
 DO DEBUG
 LDA #" "
 JSR COUT
 FIN
 JSR SOGETUDPSOBY
 BCC :SOCKFOUND
* SOCKET NOT FOUND HERE
* SEND AN ICMP PORT UNREACHABLE ERROR, BUT ONLY
* IF THIS WAS NOT A MULTI- OR BROADCAST MESSAGE
 DO DEBUG
 LDA #"*"
 JSR COUT
 FIN
 LDA BCASTFLAG ; BROADCAST?
 BNE :UDPDONE
*
* TODO: CHECK MULTICAST FLAG HERE
*
 LDA #ICMPUNREACH
 STA ICMPERRTYPE
 LDA #3 ; PORT UNREACHABLE
 STA ICMPERRCODE
 JSR ICMPERROR
:UDPDONE
 RTS
*
* SOCKET WAS FOUND
* SET ITS READY TO READ FLAG
*
:SOCKFOUND
 DO DEBUG
 PHA ; SAVE SOCKET ID
 FIN
 JSR SOGETSOBYID ; WE ASSUME THIS WILL SUCCEED
 LDA SOTABOPT,X
 ORA #SORDYTOREAD ; SET THE READY TO READ FLAG
 STA SOTABOPT,X
 DO DEBUG
 PLA  ; GET ID BACK FOR DEBUG OUTPUT
 JSR PRBYTE ; PRINT SOCKET ID
 LDA #"$"
 JSR COUT
 FIN
 RTS
*
*
*
* UDP TRANSMIT ROUTINES
*
*
* UDP SEND
* SENDER STORES HIS ARGUMENTS, SOURCE AND DEST PORT,
* DIRECTLY IN OUTPHEAD.
*
* CALLER NEEDS TO HAVE STORED ALL REQUIRED IP MODULE
* ARGUMENTS AND UDP ARGUMENTS BEFORE CALLING THIS!
*
UDPSEND
 LDA #8 ; LENGTH OF UDP HEAD
 STA OUTPHLEN
 LDY #39 ; OFFSET TO UDP LENGTH
 CLC
 LDA OUTPLEN
 ADC #8 ; ADD LENGTH OF UDP HEAD
 STA OUTPHEAD,Y ; LOW-BYTE
 DEY
 LDA OUTPLEN+1
 ADC #0
 STA OUTPHEAD,Y ; HIGH-BYTE
* SET PROTOCOL IN IP HEAD
 LDY #23
 LDA #PROTOUDP
 STA OUTPHEAD,Y
* INITIALIZE IP LENGTH FIELD
 LDA #8
 LDY #17
 STA OUTPHEAD,Y
 DEY
 LDA #0
 STA OUTPHEAD,Y ; HIGH-BYTE
* WE CAN'T COMPUTE THE UDP CHECKSUM UNTIL THE IP MODULE
* HAS HAD A TURN TO DO SOME PROCESSING.
 JSR IPPREP
* NOW THERE IS A COMPLETE IP HEADER, SO WE CAN DO THE UDP
* CHECKSUM.
 CLC
 LDA #<OUTPHEAD
 ADC #ETHHLEN ; SKIP ETHERNET HEAD
 STA PTR
 LDA #>OUTPHEAD
 ADC #0
 STA PTR+1
* UDP DATA POINTER
 LDA OUTPBUF
 STA PTR2
 LDA OUTPBUF+1
 STA PTR2+1
 LDA OUTPLEN
 STA CHKSUMLEN
 LDA OUTPLEN+1
 STA CHKSUMLEN+1
* CLEAR THE CHECKSUM FIELD
 LDA #0
 LDY #40
 STA OUTPHEAD,Y
 INY
 STA OUTPHEAD,Y
 JSR UDPCHKSUM
* STORE UDP CHECKSUM IN OUTPHEAD
* IF THE COMPUTED CHECKSUM IS ZERO, IT IS SENT AS ALL ONES.
 ORA CHKSUM+1 ; ALL ZERO CHKSUM?
 BNE :STORE
* SET TO ALL ONES
 LDA #$FF
 STA CHKSUM
 STA CHKSUM+1
:STORE
 LDY #40 ; OFFSET TO UDP CHECKSUM
 LDA CHKSUM
 STA OUTPHEAD,Y
 INY
 LDA CHKSUM+1
 STA OUTPHEAD,Y
* NOW SEND THE DATAGRAM TO THE IP MODULE
 JSR IPSEND
 RTS
*
*
* COMPUTE UDP CHECKSUM
* SO THAT THIS CAN BE USED FOR SEND AND RECEIVE, IT USES
* 2 POINTERS: PTR TO IP HEAD, AND PTR2 TO DATA PAYLOAD.
* STORE DATA PAYLOAD LENGTH IN CHKSUMLEN.
* RESULT IS STORED IN CHKSUM.
*
* PART OF THIS ROUTINE IS ALSO USED FOR TCPCHKSUM; SEE
* ALTERNATE ENTRY POINT BELOW
*
UDPCHKSUM
 LDA #0
 STA CHKSUM ; ZERO OUT CHECKSUM
 STA CHKSUM+1
 CLC
* SUM THE PSEUDO HEADER
 LDY #12 ; OFFSET TO SOURCE ADDRESS
 LDX #7 ; COUNT DOWN
:L LDA (PTR),Y
 ADC CHKSUM
 STA CHKSUM
 INY
 DEX
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 DEX
 BPL :L
* ZERO
 LDA #0
 ADC CHKSUM
 STA CHKSUM
* PROTOCOL
 LDY #9 ; OFFSET TO PROTOCOL
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 PHP ; PRESERVE CARRY
 CLC
 LDA IPHEADLEN
 ADC #4 ; OFFSET TO UDP LENGTH
 TAY
 PLP
 LDA (PTR),Y
 ADC CHKSUM
 STA CHKSUM
 INY
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
* NOW SUM THE UDP HEADER
 LDY IPHEADLEN ; OFFSET TO UDP HEAD
 LDX #7 ; COUNT DOWN TO AVOID CPX
:L2 LDA (PTR),Y
 ADC CHKSUM
 STA CHKSUM
 DEX
 INY
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 DEX
 BPL :L2
* NOW SUM THE DATA. THIS IS WHERE WE SWITCH TO PTR2
* THIS IS THE ALTERNATE ENTRY POINT USED IN TCPCHKSUM
UDPCHKSUM2
 LDY #0
 LDA CHKSUMLEN
 ORA CHKSUMLEN+1
 BEQ :DONE ; ZERO-LENGTH PAYLOAD
 LDA CHKSUMLEN+1
 BEQ :END ; ONLY 1 PAGE OF DATA
 TAX
:L3 LDA (PTR2),Y
 ADC CHKSUM
 STA CHKSUM
 INY
 LDA (PTR2),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 BNE :L3
 INC PTR2+1 ; START READING FROM NEXT PAGE
 DEX
 BNE :L3
 LDA CHKSUMLEN
 BEQ :DONE2 ; EXACT MULTIPLE OF 256
:END
 LDX CHKSUMLEN ; COUNT DOWN
:END2 LDA (PTR2),Y
 ADC CHKSUM
 STA CHKSUM
 INY
 DEX
 BEQ :DONE ; EXIT HERE ONLY IF ODD
 LDA (PTR2),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 DEX
 BNE :END2
 BEQ :DONE2 ; EXIT HERE IF EVEN
:DONE   ; ADD AN EXTRA ZERO
 LDA #0
 ADC CHKSUM+1
 STA CHKSUM+1
:DONE2 BCC :FINAL
:CARRY
 LDA CHKSUM
 ADC #0
 STA CHKSUM
 BCC :FINAL
 LDA CHKSUM+1
 ADC #0
 STA CHKSUM+1
 BCS :CARRY
:FINAL LDA CHKSUM+1
 EOR #$FF
 STA CHKSUM+1
 LDA CHKSUM
 EOR #$FF
 STA CHKSUM
 RTS
*
* ICMP ROUTINES FOR UDP - 04 JUL 15
*
* SEE ICMP.S FOR AN OUTLINE OF HOW ICMP ERRORS ARE PASSED
* BACK TO THE SOCKETS INTERFACE.
*
*
* UDP ICMP ERR
* THIS IS CALLED BY THE ICMP HANDLER WHEN IT DETERMINES THAT
* THE DATA PAYLOAD IS A UDP DATAGRAM. THIS ROUTINE LOOKS FOR
* AN ACTIVE SOCKET THAT MATCHES THE DATAGRAM, IF ANY.
*
UDPICMPERR
 LDX #SOMAX-1 ; NUMBER OF ENTRIES TO SCAN
:CHECKSOCK
 LDA SOTABID,X ; IS THIS SOCKET IN USE?
 BNE :N
 JMP :NEXTSOCK ; NO, SKIP
:N
 LDA SOTABTYPE,X ; CHECK SOCKET TYPE
 AND #%01111111 ; MASK OUT CONNECTED FLAG
 CMP #SOTYPEUDP ; A UDP SOCKET?
 BEQ :N2 ; YES!
 JMP :NEXTSOCK ; NO, SKIP
:N2
* THIS IS AN ACTIVE UDP SOCKET, SO CHECK IF IT WAS THE CULPRIT
 LDY #0 ; OFFSET TO SOURCE PORT IN ERR
 LDA (INPBUF),Y ; GET HI-BYTE UDP SRC PORT
 CMP SOTABLPTH,X ; CHECK SOCKET'S LOCAL PORT
 BNE :NEXTSOCK ; PORT MISMATCH, SKIP
 INY
 LDA (INPBUF),Y ; LO-BYTE
 CMP SOTABLPTL,X
 BNE :NEXTSOCK
* IF SOCKET IS NOT CONNECTED, THEN WE'VE FOUND A MATCH.
 LDA SOTABTYPE,X
 AND #SOCONN
 BNE :ISCONN ; SOCKET IS CONNECTED
* SOCKET NOT CONNECTED, WE'RE DONE
 LDA SOTABID,X
 CLC
 RTS
:ISCONN
* SOCKET IS CONNECTED, 2 MORE CHECKS NEEDED
 LDY #2 ; OFFSET FOR DEST PORT
 LDA (INPBUF),Y ; GET HI-BYTE UDP DEST PORT
 CMP SOTABFPTH,X
 BNE :NEXTSOCK
 INY
 LDA (INPBUF),Y
 CMP SOTABFPTL,X
 BNE :NEXTSOCK
* NOW FOREIGN PORT MATCHES SO CHECK FOREIGN ADDRESS
* GET SOCKET TABLE OFFSET FOR FOREIGN ADDRESS
 TXA
 PHA
 ASL
 ASL
 TAX
 LDY #0 ; IPINSRC OFFSET
:FAL LDA IPINSRC,Y
 CMP SOTABDEST,X
 BNE :FANOMATCH ; ADDRESS DOES NOT MATCH
 INX
 INY
 CPY #4
 BNE :FAL
* IF WE MAKE IT HERE, THEN THE ADDRESSES MATCH
 PLA
 TAX
 LDA SOTABID,X
 CLC
 RTS
:FANOMATCH
 PLA
 TAX
:NEXTSOCK
 DEX ; MOVE TO NEXT SOCKET ENTRY
 BPL :CHECKSOCK
:NOSOCKMATCH
 SEC
 RTS
